/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorRespectModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> RESPECT = TConstruct.createKey((String)"respect_armor");

    public ArmorRespectModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, ArmorRespectModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(RESPECT, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(RESPECT, (Object)0);
            if (level > 0 && living instanceof Player) {
                Player player = (Player)living;
                if (attacker != null) {
                    Vec3 vec3 = player.m_20252_(1.0f).m_82541_();
                    Vec3 vec31 = new Vec3(living.m_20185_() - attacker.m_20185_(), living.m_20188_() - attacker.m_20188_(), living.m_20189_() - attacker.m_20189_());
                    double d0 = vec31.m_82553_();
                    double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
                    if (d1 <= 1.0 - 0.025 / d0 && !player.m_142582_(attacker)) {
                        event.setAmount(event.getAmount() * (1.0f - 0.2f * (float)Math.min(3, level)));
                    }
                }
            }
        });
    }
}

